<?php
// functions.php - small utilities
function e($v){ return htmlspecialchars($v, ENT_QUOTES, 'UTF-8'); }

function sanitize_contact($data){
  return [
    'name' => trim(strip_tags($data['name'] ?? '')),
    'email' => filter_var(trim($data['email'] ?? ''), FILTER_VALIDATE_EMAIL) ? trim($data['email']) : '',
    'message' => trim(strip_tags($data['message'] ?? ''))
  ];
}

function send_contact($name, $email, $message){
  // NOTE: mail() must be configured on your server. For development inspect values instead.
  $to = 'you@example.com'; // <-- change to your destination email
  $subject = "Contact from HealthyLife: " . substr($name,0,50);
  $body = "Name: $name\nEmail: $email\n\nMessage:\n$message";
  $headers = "From: $name <$email>\r\nReply-To: $email\r\n";
  return mail($to, $subject, $body, $headers);
}
