<?php
require __DIR__ . '/includes/functions.php';
$pageTitle = 'Contact — HealthyLife';
$status = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST'){
  $data = sanitize_contact($_POST);
  if (empty($data['name']) || empty($data['email']) || empty($data['message'])){
    $status = 'Please complete all fields.';
  } else {
    $ok = send_contact($data['name'], $data['email'], $data['message']);
    $status = $ok ? 'Message sent — thank you!' : 'Failed to send message. For testing check mail() config.';
  }
}
require __DIR__ . '/includes/header.php';
?>
<section class="card">
  <h2>Contact Us</h2>
  <?php if($status): ?><p><strong><?= e($status) ?></strong></p><?php endif; ?>
  <form method="post" action="">
    <div class="form-row"><label>Name</label><input type="text" name="name" required></div>
    <div class="form-row"><label>Email</label><input type="email" name="email" required></div>
    <div class="form-row"><label>Message</label><textarea name="message" rows="6" required></textarea></div>
    <button type="submit">Send Message</button>
  </form>
</section>

<?php require __DIR__ . '/includes/footer.php'; ?>
